# Documentos de BITNATION y Pangea, recursos y directrices del contribuyente

:v: La comunidad es una de las fuerzas motrices de BITNATION. Para ser resilientes, necesitamos una comunidad descentralizada de contribuyentes, tanto como una tecnología descentralizada. No importa cuál sea tu profesión, tu nivel de habilidad, tu nacionalidad, edad, educación o género. Todos son bienvenidos a unirse para ayudar a que BITNATION y nuestro software de Pangea sean un éxito que cambie el statu quo de la gobernanza. :earth_americas::earth_asia::earth_africa:

Para conocernos, el mejor lugar para comenzar es a través de:

- Únete a nuestra comunidad en [Slack](https://bitn.slack.com).
- Participa en [tareas de la comunidad](https://trello.com/b/c6ckOIxF/bitnation-generic) en Trello.
- Participa en [tareas de desarrollo](https://trello.com/b/8L5zsyzM/bitnation-dev-internal) en Trello.
- Ve la [hoja de ruta de desarrollo](https://trello.com/b/rb43zuUn/bitnation-dev) en Trello.
- Contribuye a nuestro código en [GitHub](https://github.com/Bit-Nation).

Visita el [sitio web de Bitnation](https://bitnation.co/), y el [sitio web de Pangaea](https://tse.bitnation.co/index.html).

Si deseas familiarizarte con Bitnation, aquí hay algunos documentos claves que leer:

---

## BITNATION Resumen y filosofía:

- Pangea [Whitepaper](https://github.com/Bit-Nation/Pangea-Docs/blob/master/BITNATION%20Pangea%20Whitepaper%202017.pdf) 2017.
 - Liquid Holocracy DBVN [Constitución](https://github.com/Bit-Nation/BITNATION-Constitution) 2016.
 - BITNATION [Whitepaper](https://github.com/Bit-Nation/Pangea-Docs/blob/master/Bitnation%20Whitepaper%202014.pdf) 2014.
 - [Documento fundacional](https://docs.google.com/document/d/16HDB9AABa5rTOVFJj_8VLdOxgMguovLLAMviaTkZ1q4/edit) 2014.
 - [Documento pre-fundacional](https://blog.bitnation.co/what-is-bitnation-the-googlement/) 2014.

### BITNATION y la historia de Pangea:

- [Resumen anual](https://steemit.com/introduce-yourself/@bitnation/bitnation-yearly-summary-the-year-of-pangea-by-tarkowski-tempelhof) 2015-2016.
- [Resumen anual](https://medium.com/@susannetarkowskitempelhof/bitnation-year-1-summary-6a1c40b4ee5a) 2014-2015.

### Canales de medios:

- [Página de Facebook](https://www.facebook.com/Bitnation-Pangea-337620226422880/).
- [Grupo de Facebook](https://www.facebook.com/groups/704796139595313/).
- [Twitter](https://twitter.com/MyBitNation).
- [Blog](https://steemit.com/@bitnation).
- [Steemit](https://steemit.com/bitnation/@bitnation).

### MISC:
- [Wiki de la comunidad](https://github.com/Bit-Nation/Pangea-Docs/wiki).
- [Página de Wikipedia](https://www.wikiwand.com/en/Bitnation).
- [Directrices OPSEC de la comunidad](https://docs.google.com/document/d/1E9uVmuW9_zhoStrcvkuK-3kg30ec7Qgj3qG4aK7IAic/edit).
- [Lista de artículos y videos](https://angel.co/bitnation/activity).
- [Lista de inversionistas ángel](https://angel.co/bitnation).
---

## Recursos de la comunidad

Si deseas contribuir al crecimiento de la comunidad de Bitnation y de nuestra misión, este es el lugar para ti.

El mejor lugar para conocer a la comunidad es unirse a nuestro canal [Slack](https://bitn.slack.com) y comenzar a contribuir.
Es útil escribir una breve introducción sobre ti y sobre lo que te interesa hacer. Ten en cuenta que el chat de Slack *no* está encriptado, y está abierto para que cualquiera pueda unirse, por lo tanto, no compartas nada que creas que podría comprometer tu seguridad, y usa un seudónimo si quieres seguir siendo anónimo.

Los canales populares a los que puedes unirte incluyen `# _dev`, `#_marketing`, `#townhall`,  `#intros` y `#watercooler`.

La comunidad de Slack se trasladará a Pangea después del lanzamiento de Beta.

### Únete a las redes Ambassador y Embassy

Las redes Ambassador y Embassy fueron concebidas como versiones análogas de Pangea. Una red del mundo real de personas y lugares donde los nómadas digitales pueden obtener asesoramiento, asistencia entre pares, reunirse y pasar el rato. Hay tres tipos de representantes de Bitnation:
- Embajadores Diplomáticos: Puestos oficiales de Bitnation para realizar tareas como Oficiales que trabajan como nuestra interfaz con las Naciones existentes, así como también nuevas Naciones virtuales.
 - Cónsules diplomáticos: También un puesto oficial. Un apoyo tanto para nuestros Embajadores como para las embajadas y consulados de los Estados Nacionales que se relacionan con nuestros ciudadanos en la ubicación de nuestras embajadas y consulados.
 - Embajadores de buena voluntad: Representante informal pero oficialmente reconocido de Bitnation durante eventos (como DEVCON). Promueve y apoya Bitnation y nuestros servicios, y proporciona un punto de contacto para nuestros ciudadanos.

Las embajadas y los consulados comparten su espacio, ya sea una oficina, una cafetería o su casa, y lo abren para sus conciudadanos, hackers y criptógrafos de todo el mundo. Hay dos tipos de lugares, embajadas y consulados.
 - Embajada: Un lugar donde puedes vivir y trabajar (y, naturalmente, reunirte con otros).
 - Consulado: Un lugar donde puedes trabajar, como un espacio de oficina compartido o una cafetería, por ejemplo, o tal vez organizar una reunión o un lugar para pasar el tiempo.

Bitnation tiene más de 100 embajadas, consulados en todo el mundo. Puedes obtener más información sobre la [Red de Embajadores](https://bitnation.co/ambassador-network/) o [Registrarse como una Embajada](https://bitnation.co/embassy-consulate-directory/) en nuestro sitio web. **Todas estas funciones pronto se trasladarán del sitio web al software Pangea.**

### Comienza tu propia Nación

El software Pangea está configurado para que tú crees tu propia Nación Voluntaria Descentralizada Sin Fronteras (DBVN por sus siglas en inglés). Sin embargo, hasta que Pangea v.03 esté disponible, puedes hacerlo tú mismo mediante nuestro código DBVN. Aquí hay algunos recursos para ayudarte a configurar tú propia Nación:

 - La [infraestructura BITNATION](https://github.com/Bit-Nation/BITNATION-Framework).
 - El [antiguo código DBVN](https://github.com/Bit-Nation/BITNATION-Constitution/tree/master/dapp).
 - Este [cuestionario](https://github.com/Bit-Nation/Pangea-Docs/blob/master/create-your-own-nation.pdf) para ayudarlo a planificar su Nación.
 - Nuestro [centro de recursos DBVN](https://bitnation.co/nations-resources/?la=en).
 - Algunos [consejos](https://steemit.com/blockchain/@bitnation/create-your-own-nation-by-tarkowski-tempelhof)...

### Envia una idea de proyecto de gobernanza local o global

Puedes [enviar una idea](https://bitnation.consider.it/?tab=Show%20all) para un proyecto de gobernanza local o global en nuestro sitio web, y votar y analizar los pros y los contras de la propuesta de otras personas. Ten en cuenta que es probable que obtengas más comentarios si tu propuesta tiene objetivos claros y específicos, cronogramas, resultados esperados y resultados mensurables.

Por ahora, la página del Proyecto es principalmente para discutir ideas, pero después de la ICO podremos financiar algunas de ellas a través de Smart Contracts.

### Ayuda con documentación, traducción y recursos educativos

Una buena documentación es clave para un movimiento de software de código abierto.
 - Ayuda para documentar las mejores prácticas, eventos clave, procesos, etc.
 - Traducir materiales como Libros blancos, actualizaciones de la comunidad, artículos, videos. Estamos configurando [este recurso](https://crowdin.com/project/bitnation-documentation) para ayudar a colaborar en las traducciones.
 - Crea manuales, videos y publicaciones en blogs para ayudar a explicar cómo ser parte de la comunidad y cómo usar el software.

### Ayuda a crecer nuestra comunidad a través del alcance y el compromiso

Hay muchas maneras de ayudar a que el movimiento crezca a través del alcance y la comunicación. Aquí hay una lista de algunas actividades que son realmente impactantes.
 - Organizar Google Hangouts en línea y Meetups locales.
 - Producir contenido, como videos de YouTube, videos de demostración de software, materiales gráficos, publicación de blog, etc.
 - Ayudar a los nuevos participantes en Slack a entender BITNATION y orientarse por los canales de Slack y otros recursos (como este aquí).
 - Ayudar a las personas fuera de nuestra comunidad a entender más acerca de BITNATION, el software Pangea, las criptomonedas, las tecnologías descentralizadas, la importancia de la privacidad y la seguridad y todo lo demás hermoso en el mundo :smile:.

### Código de conducta de la comunidad

El [Código genérico de conducta del ciudadano](http://citizencodeofconduct.org/) está [aplicado](https://github.com/Bit-Nation/Pangea-Docs/blob/master/CODE_OF_CONDUCT.md) a la mayoría de los repositorios y canales dentro de BITNATION. Sin embargo, aquí hay algunos valores que nos gustaría destacar más específicamente.

- **Claridad sobre todas las cosas** Comprender los desafíos de la comunicación a través de diferentes husos horarios, cultura y personalidades tanto durante las comunicaciones escritas como verbales. Es aconsejable evitar declaraciones radicales a favor de oraciones claramente articuladas con propósitos bien definidos.
 - **Abstenerse de sacar conclusiones precipitadas** Un problema fundamental en muchas conversaciones es que sobreestimamos la capacidad de los demás para comprender nuestras comunicaciones escritas y verbales, y sobreestimamos nuestra propia capacidad para comprender lo que están tratando de comunicar. Al analizar lo que la otra persona intenta comunicar, ten en cuenta su contexto, incluidos aspectos como la zona horaria, el idioma nativo y las circunstancias personales.
 - **Respeto** Nos hemos unido para cambiar el statu quo mediante la creación de software radical, por lo que ser irrespetuoso puede desviar la conversación de nuestro propósito establecido a áreas irrelevantes. Los desaires personales y los ataques no fomentan un buen espacio de colaboración; es aconsejable evitarlos. Cuando nos sentamos emocionalmente afectados por alguna conversación, debemos intentar dar un paso atrás y mantener la calma.
---

## Recursos de desarrollo

### Empezando

La mejor forma de involucrarte en el proceso de desarrollo es al unirte a nuestro [Slack](https://bitn.slack.com) después de leer la siguiente documentación. Los canales relevantes de Slack son `#dev` para discusiones generales de desarrollo, y `#dev-bots` para notificaciones push en tiempo real de GitHub, Trello y TravisCI.

### Idiomas e infraestructura

 - Panthalassa, nuestro backend de red de malla se construyó inicialmente en [Golang](https://github.com/Bit-Nation/BITNATION-Panthalassa), pero actualmente se está refabricando en TypeScript, sigue el desarrollo [aquí](https: / /github.com/Bit-Nation/BITNATION-Panthalassa-TS).
 - [Pangea](https://github.com/Bit-Nation/BITNATION-Pangea-react) es nuestro interfaz bajo una fuerte remodelación, esta nueva versión está hecha con React Native.
 - El [Entiy Framework](https://github.com/Bit-Nation/BITNATION-Framework) está hecho en Solidity.
 - El [registro](https://github.com/Bit-Nation/BITNATION-Registry) se integrará en la infraestructura, también está en solidario.

### Whitepaper, hoja de ruta y actualizaciones de desarrollo

 - [Whitepaper](https://github.com/Bit-Nation/Pangea-Docs/blob/master/BITNATION%20Pangea%20Whitepaper%202017.pdf).
 - [Hoja de ruta del desarrollo de alto nivel y lista de tareas](https://trello.com/b/rb43zuUn/bitnation-dev).
 - [Abrir tareas de desarrollo](https://trello.com/b/8L5zsyzM/bitnation-dev-internal) en Trello.
 - Las [actualizaciones de desarrollo regulares](https://steemit.com/@bitnation) son publicadas en Steemit.

### Repositorios clave

Estamos fijando repositorios relevantes en nuestro [perfil](https://github.com/Bit-Nation).

### API y documentación

  - [Panthalassa REST JSON API](https://github.com/Bit-Nation/BITNATION-Panthalassa/blob/master/api/api.go).
  - [Documentación de Panthalassa Swagger](https://github.com/Bit-Nation/BITNATION-Panthalassa/blob/master/api/panthalassa.yaml).

### Recursos de UI / UX

 - Los asuntos de UI / UX se discuten en Slack y se suben a Trello.
 - Échale un vistazo a nuestro [repositorio de directrices de marca](https://github.com/Bit-Nation/Bitnation-Branding-Guidelines) donde encontrarás recursos como marcas y archivos fuente de UI.
 - Los archivos de origen de nuestro [logo](https://github.com/Bit-Nation/Bitnation-Branding-Guidelines/tree/master/Logo%20And%20Branding%20Files)
 - Nuestras directrices de [tipografía](https://github.com/Bit-Nation/Bitnation-Branding-Guidelines/blob/master/Logo%20And%20Branding%20Files/Font-Guide.md)

### Contratos de solidez

 - [Token de Arbitraje de Pangea](https://github.com/Bit-Nation/Pangea-Arbitration-Token-PAT) (PAT) Estándar ERC20
 - [Evento de venta de tokens](https://github.com/Bit-Nation/Token-Sale-Event-TSE) (TSE). El código está siendo reelaborado.
 - [Mapa de Pangea](https://github.com/Bit-Nation/BITNATION-Map) (de Ciudadanos, Embajadas, Consulados, etc.)
 - [Registro de Pangea](https://github.com/Bit-Nation/BITNATION-Registry) (de Holons, Naciones, Embajadas, etc.)
 - [Pangea DBVN Entity Framework](https://github.com/Bit-Nation/BITNATION-Framework)

### Modelo de lanzamiento

 - Siguiendo la metodología [Scrum](https://en.wikipedia.org/wiki/Scrum_ (software_development)) usaremos lanzamientos de sprint siempre que sea posible.
 - Antes de hacer un lanzamiento, nos estamos asegurando de que pasen todas las pruebas unitarias.

### Pruebas de software, bonificaciones de errores e informes de errores

Estamos tratando de maximizar nuestra cobertura de prueba de código, por lo tanto, todos los repositorios diferentes se envían con pruebas de unidad que cumplen con el estándar de lenguaje o infraestructura.

 - La versión actual de la interfaz de Pangea React se está construyendo [aquí](https://github.com/Bit-Nation/BITNATION-Pangea-react), por favor revísalo y contribuye.
 - Puedes probar la aplicación Pangea en tu teléfono móvil utilizando expo.io, simplemente instala expo.io y escanea el [código QR](https://expo.io/@danielfranca/bitnation) con tu teléfono.

- La versión anterior de [Pangea](https://github.com/Bit-Nation/BITNATION-Pangea) se puede probar a través de `npm` gracias a` npm run test` (por favor, primero instala las dependencias con `npm install`)
 - Se utiliza [Travis CI](https://travis-ci.org/Bit-Nation) por defecto en los repositorios de claves
 - [Panthalassa](https://github.com/Bit-Nation/BITNATION-Panthalassa) admite la infraestructura de prueba de golang, usa `go test -v. / ...` en el proyecto clonado (después de descargar las dependencias).
 - El [Entity Framework](https://github.com/Bit-Nation/BITNATION-Framework) usa truffle, todo se incluye a través de `npm` después de instalar dependencias a través de` npm install`, simplemente haz `npm run test`.
 - Las informaciones sobre el registro se detallan en su [readme](https://github.com/Bit-Nation/BITNATION-Registry/blob/master/README.md).
 - Los contratos clave de Solidez son auditados por auditores externos, principalmente [Consultores ABDK](https://www.abdk.consulting/).

### Directrices para comprometer el código y el código de conducta

 - Algunos repositorios incluyen plantillas de solicitud de problema o extracción, úsalas siempre que sea posible.
 - Mantén los mensajes de compromiso claros e intenta seguir el mismo patrón que el utilizado en el repositorio de destino.
 - Evita duplicar cualquier problema o solicitud de extracción, **se cerrará cualquier duplicado**.
 - Divide tus diferentes cambios de forma clara a través de commits, facilitará la tarea del revisor.
 - Solo se debe enviar un cambio importante por solicitud de extracción, ¡ayúdanos a revisar tu código más rápido!
 - Por último, pero no menos importante: se respetuoso, nunca se tolerarán abusos y podría dar como resultado el cierre de tu solicitud de problema/extracción sin previo aviso.

### Recursos de aprendizaje adicionales:

 - [Whitepaper de Ethereum](https://github.com/ethereum/wiki/wiki/White-Paper)
 - [Whitepaper de IPFS](https://github.com/ipfs/ipfs/blob/master/papers/ipfs-cap2pfs/ipfs-p2p-file-system.pdf)
 - [Whitepaper de Rootstock](http://www.the-blockchain.com/docs/Rootstock-WhitePaper-Overview.pdf)
 - [Aprende Solidity](http://solidity.readthedocs.io/en/develop/)
 - [Aprende Golang](https://golang.org/doc/#learning)
 - [Aprende React](https://facebook.github.io/react/tutorial/tutorial.html)

> Hecho con :heart: en BITNATION.
